; Copyleft (c) n/a-n/a Azure Zanculmarktum

!define SETUPURL    "http://www.extendoffice.com/downloads/${SETUPFILE}"
!define SETUPFILE   "SetupOfficeTabMSI.msi"
!define FILENAME    "Office_Tab_Portable_9.x_${APPLANG}_Setup_Extactor"
!define APPNAME     "Office Tab"
!define APP         "OfficeTab"
!define APPVER      "0.0.0.0"
!define VER         "0.0.0.0"
!define APPLANG     "Multilingual"
!define FOLDER      "OfficeTabPortable"
!define LAUNCHER    "OfficeTabPortable"
!define APPDIR      "OfficeTab"
!define SOURCE
!define INIT
!define COMMONFILESPLUGIN
!define SETUPEXTRACTOR

; === Best Compression ===
SetCompress Auto
SetCompressor /SOLID lzma
SetCompressorDictSize 32
SetDatablockOptimize On

; === Include ===
!include Include\Installer.nsh

Section "${APPNAME} Portable" Main
	SetDetailsPrint textonly
	DetailPrint "Extracting ${APPNAME} Portable..."
	SetDetailsPrint listonly
	SetDetailsView hide

	SectionIn RO

	; === Start with a clean temporary directory ===
	RMDir "/r" "$TEMP\${APP}PortableTemp"
	CreateDirectory "$TEMP\${APP}PortableTemp"

	; === Check msiexec ===
	File "/oname=$TEMP\${APP}PortableTemp\TryMe.msi" "Include\TryMe.msi"
	nsExec::Exec `"$SYSDIR\msiexec.exe" /a "$TEMP\${APP}PortableTemp\TryMe.msi" TARGETDIR="$TEMP\${APP}PortableTemp\TestMSI" /qn`
	IfFileExists "$TEMP\${APP}PortableTemp\TestMSI\Program Files\TryMe\TryMe.MM\TryMe.ICO" +3
		MessageBox MB_ICONEXCLAMATION "Your system can't run msiexec to extract files from setup.$\nIf you have:$\n$SYSDIR\msiexec.exe$\nTry to disable securities."
		Goto Cancelled

	${If} $INSTALLERTYPE == "Offline"
		; === Extract files from the setup ===
		nsExec::Exec `"$SYSDIR\msiexec.exe" /a "$INPUTFILE" TARGETDIR="$TEMP\${APP}PortableTemp\${APP}Setup" /qn`
	${ElseIf} $INSTALLERTYPE == "Online"
		; === Download setup file ===
		inetc::get "${SETUPURL}" "$OUTPUTDIR\${SETUPFILE}" /END
		Pop $0
		StrCmp $0 "OK" +3
			MessageBox MB_USERICON "Download of ${SETUPFILE}: $0"
			Goto Cancelled

		; === Extract files from the setup ===
		nsExec::Exec `"$SYSDIR\msiexec.exe" /a "$OUTPUTDIR\${SETUPFILE}" TARGETDIR="$TEMP\${APP}PortableTemp\${APP}Setup" /qn`
	${EndIf}

	!ifndef COMMONFILESPLUGIN
		SetOutPath "$INSTDIR"
			File /x thumbs.db "..\..\${LAUNCHER}.exe"
		!ifndef LANGDIR
			SetOutPath "$INSTDIR\App\${APPDIR}"
				File /r /x thumbs.db "..\..\App\${APPDIR}\*.*"
		!else
			SetOutPath "$INSTDIR\App\${APPDIR}"
				File /r /x thumbs.db /x ${LANGDIR} "..\..\App\${APPDIR}\*.*"
		!endif
	!else
		SetOutPath "$INSTDIR\CommonFiles\${APPDIR}"
			File "..\..\${LAUNCHER}.exe"
		CreateDirectory "$INSTDIR\CommonFiles\${APPDIR}\files"
			CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup\ArmAccess.dll" "$INSTDIR\CommonFiles\${APPDIR}\files"
			CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup\TabsforOffice32.dll" "$INSTDIR\CommonFiles\${APPDIR}\files"
			CopyFiles /SILENT "$TEMP\${APP}PortableTemp\${APP}Setup\TabsforOfficeHelper32.dll" "$INSTDIR\CommonFiles\${APPDIR}\files"
	!endif

	Call AppInfo

	Call Help

	Call Source

	Cancelled:
SectionEnd

!ifdef INIT
	Function Init
		; === Destroy size lol ===
		SectionSetSize ${Main} 0
	FunctionEnd
!endif

Function .onGUIEnd
	; === Remove temporary directory ===
	RMDir "/r" "$TEMP\${APP}PortableTemp"
FunctionEnd